PROGRAM uncompress_file

  IMPLICIT NONE

  integer*4 :: ncol, nlin
  character(len=120) :: carg, cfile_in, cfile_out, cfile_cover_out

  integer*4, dimension(:), allocatable :: nbval ! dim nlin
  integer*2, dimension(:), allocatable :: lread ! dim ncol
  integer*4, dimension(:), allocatable :: lread2 ! dim ncol
  integer*1, dimension(:), allocatable :: lwrite ! dim ncol
  integer*1, dimension(:), allocatable :: lwrite_cover ! dim ncol
  integer*4 :: j, i, k, icpt
  integer*1 :: ok

  ! Valeurs par défaut
  ncol = 129600 ! de 180W à 180E res 10"
  nlin = 64800 ! de 90N à 90S res 10"
  cfile_cover_out = ""

  ! Lecture des arguments
  if (iargc() >= 2 .and. iargc() <= 5) then
     ! fichier en entrée
     call getarg(1, cfile_in)
     ! fichiers en sortie
     call getarg(2, cfile_out)
     ! arguments optionnels
     do i=3, iargc()
        call getarg(i, carg)
        if (carg(1:5) == 'rows=') then
           read(carg(6:),*,iostat=ok) nlin
           if (ok /= 0) then
              print*, "Erreur lecture rows (",carg(6:),")"
              stop
           endif
        elseif (carg(1:5) == 'cols=') then
           read(carg(6:),*,iostat=ok) ncol
           if (ok /= 0) then
              print*, "Erreur lecture cols (",carg(6:),")"
              stop
           endif
        else
           ! fichier de cover en sortie
           cfile_cover_out = carg
        endif
     enddo
  else
     call getarg(0, carg)
     print*, "Usage : ",trim(carg), " <file_in> <file_out> [<file_cover_out>] [rows=<rows> cols=<cols>]"
     print*,"-> maps from 90N to 90S (res 10sec) : rows=64800 cols=129600 (default)"
     print*,"-> maps from 80N to 60S (res 10sec) : rows=50400 cols=129600"
     stop
  endif

  ! Allocations dynamiques
  allocate(nbval(nlin), stat=ok)
  if (ok /= 0) then
     print*, "Erreur allocation nbval"
     stop
  endif
  allocate(lread(ncol), stat=ok)
  if (ok /= 0) then
     print*, "Erreur allocation lread"
     stop
  endif
  allocate(lread2(ncol), stat=ok)
  if (ok /= 0) then
     print*, "Erreur allocation lread2"
     stop
  endif
  allocate(lwrite(ncol), stat=ok)
  if (ok /= 0) then
     print*, "Erreur allocation lwrite"
     stop
  endif
  allocate(lwrite_cover(ncol), stat=ok)
  if (ok /= 0) then
     print*, "Erreur allocation lwrite_cover"
     stop
  endif

  ! En entrée : fichier dit "compressé"
  open(11,file=cfile_in,form='unformatted',access='stream')

  ! En sortie : fichier binaire contenant la matrice des données - entiers sur 1 octet
  open(13,file=cfile_out,form='unformatted',access='direct',recl=ncol)

  ! En sortie : fichier binaire contenant la matrice des covers - entiers sur 1 octet
  if (cfile_cover_out /= "") then
     open(14,file=cfile_cover_out,form='unformatted',access='direct',recl=ncol)
  endif

  ! On lit le nombre de valeurs renseignées pour chaque ligne
  read(11) nbval

  ! Boucle sur les lignes
  do j = 1,nlin

     ! Lecture des valeurs binaires en entrée pour une ligne
     lread(:) = 0
     read(11) lread(1:nbval(j))

     ! On corrige les valeurs lues négatives
     ! (f90 ne sait pas lire directement les unsigned int)
     lread2(:) = lread(:)
     do k = 1,nbval(j)
        if (lread2(k) < 0) lread2(k) = 32768*2 + lread2(k)
     enddo

     ! Boucle sur les colonnes
     i = 1                      ! indice de l'élément lu dans lread2
     icpt = 1                   ! indice de l'élément écrit dans lwrite
     do while (icpt <= ncol) 

        ! Si la valeur lue est valide
        if (lread2(i) < 4000) then

           ! On la met dans lwrite à l'indice icpt
           lwrite(icpt) = lread2(i) - floor(lread2(i)/100.)*100.
           if (cfile_cover_out /= "") then
              lwrite_cover(icpt) = floor(lread2(i)/100.)
           endif

           icpt = icpt + 1
           i = i + 1

        else
           ! On a (valeur_lue - 4000) valeurs nulles successives
           do k = 1,lread2(i)-4000
              lwrite(icpt) = 0
              if (cfile_cover_out /= "") then
                 lwrite_cover(icpt) = 0
              endif
              icpt = icpt + 1
           enddo

           i = i+1

        endif

     enddo

     write(13,rec=j) lwrite(:)
     if (cfile_cover_out /= "") then
        write(14,rec=j) lwrite_cover(:)
     endif

  enddo

  close(11)
  close(13)
  close(14)


END PROGRAM uncompress_file
